
# Report an Issue

Please follow the guidelines below when creating an issue so that your issue can be more promptly resolved:

* Provide information including the version of PHP and HumHub, the type of operating system and Web server, MySQL version, browser type and version;
* Provide the complete error call stack if available, in addition, please check your browser console for any errors. A screenshot to explain the issue is also welcomed.
* Describe the steps for reproducing the issue. 
* If possible try to reproduce this error on our demo at https://humhub.org

**Do not report an issue if**

* you are asking how to use a HumHub feature. You should use [the community](https://community.humhub.com) for this purpose.
* your issue is about security. Please [contact us directly](mailto:info@humhub.com) to report security issues.

**Avoid duplicated issues**

Before you report an issue, please search through [existing issues](https://github.com/humhub/humhub/issues) to see if your issue is already reported or fixed to make sure you are not reporting a duplicated issue. 
Also, make sure you have the latest version of HumHub and see if the issue still exists.


# Contribute to the core code or fix bugs (Pull Requests)

Third-party patches are essential for keeping HumHub great. 
We want to keep it as easy as possible to contribute changes that get things working in your environment. 
There are a few guidelines that we need contributors to follow so that we can have a chance of keeping on top of things.

* Make sure you have a [GitHub account](https://github.com/signup/free)
* Fork the repository on GitHub
* Before we can accept your patches, you'll have to sign the Contributors License Agreement 
  * https://www.humhub.org/cla/github/sign
* Make sure there is an issue created for the thing you are working on if it requires significant effort to fix
* Open a pull request
